/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.handler.data.IDeal;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiNpcMarketSettings;
import noppes.npcs.client.gui.global.SubGuiNPCManageDeal;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Deal;
import noppes.npcs.controllers.data.DealMarkup;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarcetSection;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.CustomNPCsScheduler;

public class GuiNPCManageMarkets
extends GuiNPCInterface2
implements IGuiData,
ICustomScrollListener,
GuiYesNoCallback,
ISubGuiListener {
    public static int marcetId;
    public static int dealId;
    private static Marcet selectedMarcet;
    private static Deal selectedDeal;
    private final Map<String, Integer> dataDeals = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> dataMarkets = new TreeMap<String, Integer>();
    private GuiCustomScroll scrollMarkets;
    private GuiCustomScroll scrollDeals;
    private GuiCustomScroll scrollAllDeals;
    private MarcetController mData = MarcetController.getInstance();
    private int tabSelect;

    public GuiNPCManageMarkets(EntityNPCInterface npc) {
        super(npc);
        selectedMarcet = (Marcet)this.mData.getMarcet(marcetId);
        if (selectedMarcet != null) {
            if (selectedMarcet.getSection(dealId) >= 0) {
                IDeal[] deals = selectedMarcet.getAllDeals();
                dealId = deals.length > 0 ? deals[0].getId() : 0;
            }
            selectedDeal = (Deal)this.mData.getDeal(dealId);
        }
        this.tabSelect = 0;
        this.ySize = 200;
        Client.sendData(EnumPacketServer.TraderMarketGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.save();
                selectedMarcet = (Marcet)this.mData.addMarcet();
                marcetId = selectedMarcet.getId();
                this.func_73866_w_();
                CustomNPCsScheduler.runTack(() -> this.setSubGui(new SubGuiNpcMarketSettings(selectedMarcet)), 50);
                break;
            }
            case 1: {
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.scrollMarkets.getSelected(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 2: {
                this.setSubGui(new SubGuiNpcMarketSettings(selectedMarcet));
                break;
            }
            case 3: {
                this.save();
                SubGuiNPCManageDeal.parent = this;
                NoppesUtil.requestOpenGUI(EnumGuiType.SetupTraderDeal, marcetId, this.mData.getUnusedDealId(), 0);
                break;
            }
            case 4: {
                if (!this.dataDeals.containsKey(this.scrollAllDeals.getSelected())) {
                    return;
                }
                Client.sendData(EnumPacketServer.TraderMarketDel, -1, dealId);
                dealId = 0;
                break;
            }
            case 5: {
                if (dealId < 0) {
                    return;
                }
                SubGuiNPCManageDeal.parent = this;
                NoppesUtil.requestOpenGUI(EnumGuiType.SetupTraderDeal, marcetId, dealId, 0);
                this.close();
                break;
            }
            case 6: {
                this.tabSelect = button.getValue();
                this.func_73866_w_();
                break;
            }
            case 7: {
                if (selectedMarcet == null || selectedDeal == null) {
                    return;
                }
                int tab = selectedMarcet.getSection(selectedDeal.getId());
                if (tab == this.tabSelect) {
                    return;
                }
                GuiNPCManageMarkets.selectedMarcet.sections.get(this.tabSelect).addDeal(selectedDeal.getId());
                this.setGuiData(null);
                this.func_73866_w_();
                break;
            }
            case 8: {
                if (!this.dataDeals.containsKey(this.scrollDeals.getSelected())) {
                    return;
                }
                int id = this.dataDeals.get(this.scrollDeals.getSelected());
                GuiNPCManageMarkets.selectedMarcet.sections.get(this.tabSelect).removeDeal(id);
                this.setGuiData(null);
                this.func_73866_w_();
                break;
            }
            case 9: {
                if (this.dataDeals.isEmpty()) {
                    return;
                }
                for (int id : this.dataDeals.values()) {
                    GuiNPCManageMarkets.selectedMarcet.sections.get(this.tabSelect).addDeal(id);
                }
                this.setGuiData(null);
                this.func_73866_w_();
                break;
            }
            case 10: {
                if (this.scrollDeals.getList().isEmpty()) {
                    return;
                }
                GuiNPCManageMarkets.selectedMarcet.sections.get(this.tabSelect).removeAllDeals();
                this.setGuiData(null);
                this.func_73866_w_();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        if (id == 0) {
            if (selectedMarcet == null) {
                return;
            }
            Client.sendData(EnumPacketServer.TraderMarketDel, marcetId, -1);
            marcetId = 0;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.mData = MarcetController.getInstance();
        int w = 120;
        int h = this.ySize - 24;
        if (this.scrollMarkets == null) {
            this.scrollMarkets = new GuiCustomScroll(this, 0);
            this.scrollMarkets.setSize(w, h);
        }
        if (this.scrollDeals == null) {
            this.scrollDeals = new GuiCustomScroll(this, 1);
            this.scrollDeals.setSize(w, h);
        }
        if (this.scrollAllDeals == null) {
            this.scrollAllDeals = new GuiCustomScroll(this, 2);
            this.scrollAllDeals.setSize(w, h);
        }
        int x0 = this.guiLeft + 5;
        int x1 = x0 + w + 5;
        int x2 = x1 + w + 45;
        int y = this.guiTop + 14;
        LinkedHashMap<Integer, List<String>> htsM = new LinkedHashMap<Integer, List<String>>();
        this.scrollMarkets.setListNotSorted(new ArrayList<String>(this.dataMarkets.keySet()));
        if (!this.dataMarkets.isEmpty()) {
            int i = 0;
            for (int id : this.dataMarkets.values()) {
                Marcet marcet = (Marcet)this.mData.getMarcet(id);
                ArrayList<String> info = new ArrayList<String>();
                info.add("\u00a77ID: \u00a7r" + marcet.getId());
                info.add("\u00a77" + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + marcet.name);
                if (!marcet.isValid()) {
                    info.add(new TextComponentTranslation("market.hover.nv.market", new Object[0]).func_150254_d());
                    for (MarcetSection ms : GuiNPCManageMarkets.selectedMarcet.sections.values()) {
                        for (Deal deal : ms.deals) {
                            if (deal.isValid()) continue;
                            if (deal.getProduct().getMCItemStack() == null || deal.getProduct().getMCItemStack().func_77973_b() == Items.field_190931_a) {
                                info.add(new TextComponentTranslation("market.hover.nv.market.deal.0", new Object[]{"" + deal.getId()}).func_150254_d());
                            }
                            if (deal.getMoney() != 0 || !deal.getCurrency().isEmpty()) continue;
                            info.add(new TextComponentTranslation("market.hover.nv.market.deal.1", new Object[]{"" + deal.getId()}).func_150254_d());
                        }
                    }
                    if (info.size() > 9) {
                        info.add("...");
                        break;
                    }
                }
                htsM.put(i, info);
                ++i;
            }
        }
        this.scrollMarkets.setHoverTexts(htsM);
        this.scrollMarkets.setSelected(selectedMarcet.getSettingName());
        if (!this.dataDeals.isEmpty()) {
            ArrayList<String> allDeals = new ArrayList<String>(this.dataDeals.keySet());
            LinkedHashMap<Integer, List<String>> htsAD = new LinkedHashMap<Integer, List<String>>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            TreeMap<Integer, TempDealInfo> map = new TreeMap<Integer, TempDealInfo>();
            int i = 0;
            for (String key : this.dataDeals.keySet()) {
                Deal deal;
                int dealID = this.dataDeals.get(key);
                deal = (Deal)this.mData.getDeal(dealID);
                ArrayList<String> totalInfo = new ArrayList<String>();
                totalInfo.add("\u00a77ID: \u00a7r" + dealID);
                ArrayList<String> marcetInfo = new ArrayList<String>();
                marcetInfo.add("\u00a77ID: \u00a7r" + dealID);
                DealMarkup dm = new DealMarkup();
                if (deal != null) {
                    dm.set(deal);
                }
                ItemStack stack = ItemStack.field_190927_a;
                int tab = selectedMarcet.getSection(dealID);
                if (deal == null || !deal.isValid()) {
                    totalInfo.add(new TextComponentTranslation("market.hover.nv.deal", new Object[0]).func_150254_d());
                    if (deal == null) {
                        totalInfo.add(new TextComponentTranslation("hover.total.error", new Object[0]).func_150254_d());
                    } else {
                        stack = dm.main;
                        if (dm.main == null || dm.main.func_77973_b() == Items.field_190931_a) {
                            totalInfo.add(new TextComponentTranslation("market.hover.nv.deal.product", new Object[0]).func_150254_d());
                        }
                        if (dm.baseMoney == 0L && dm.baseItems.isEmpty()) {
                            totalInfo.add(new TextComponentTranslation("market.hover.nv.deal.barter", new Object[0]).func_150254_d());
                        }
                    }
                } else {
                    if (tab == this.tabSelect) {
                        String section = "\"" + new TextComponentTranslation(GuiNPCManageMarkets.selectedMarcet.sections.get((Object)Integer.valueOf((int)tab)).name, new Object[0]).func_150254_d() + "\"";
                        marcetInfo.add("\u00a77" + new TextComponentTranslation("gui.sections", new Object[0]).func_150254_d() + " ID: " + '\u00a7' + "r" + tab + '\u00a7' + "7; " + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + section);
                    }
                    stack = dm.main;
                    totalInfo.add(new TextComponentTranslation("market.hover.product", new Object[0]).func_150254_d());
                    totalInfo.add(dm.main.func_82833_r() + " x" + dm.count);
                    marcetInfo.add(new TextComponentTranslation("market.hover.product", new Object[0]).func_150254_d());
                    marcetInfo.add(dm.main.func_82833_r() + " x" + dm.count + (deal.getMaxCount() > 0 ? " " + new TextComponentTranslation("market.hover.item.amount", new Object[]{"" + deal.getAmount()}).func_150254_d() : ""));
                    if (!dm.baseItems.isEmpty()) {
                        totalInfo.add(new TextComponentTranslation("market.hover.item", new Object[0]).func_150254_d());
                        for (ItemStack curr : dm.baseItems.keySet()) {
                            totalInfo.add(curr.func_82833_r() + " x" + dm.baseItems.get(curr));
                        }
                    }
                    if (dm.baseMoney > 0L) {
                        totalInfo.add(new TextComponentTranslation("market.hover.currency", new Object[0]).func_150254_d());
                        totalInfo.add(dm.baseMoney + CustomNpcs.displayCurrencies);
                    }
                    totalInfo.add("\u00a7e" + new TextComponentTranslation("market.deal.type." + dm.deal.getType(), new Object[0]).func_150254_d());
                    totalInfo.add("\u00a76" + new TextComponentTranslation("drop.chance", new Object[0]).func_150254_d() + '\u00a7' + "6: " + '\u00a7' + "r" + dm.deal.getChance() + "%");
                }
                if (this.tabSelect == tab) {
                    map.put(dealID, new TempDealInfo(key, stack, marcetInfo));
                    allDeals.remove(key);
                    continue;
                }
                htsAD.put(i++, totalInfo);
                stacks.add(stack);
            }
            int j = 0;
            ArrayList<String> marcetDeals = new ArrayList<String>();
            ArrayList<ItemStack> marcetStacks = new ArrayList<ItemStack>();
            LinkedHashMap<Integer, List<String>> htsD = new LinkedHashMap<Integer, List<String>>();
            for (IDeal deal : selectedMarcet.getDeals(this.tabSelect)) {
                if (!map.containsKey(deal.getId())) continue;
                TempDealInfo tdi = (TempDealInfo)map.get(deal.getId());
                marcetDeals.add(tdi.key);
                marcetStacks.add(tdi.stack);
                htsD.put(j++, tdi.marcetInfo);
            }
            this.scrollAllDeals.setListNotSorted(allDeals);
            this.scrollAllDeals.setHoverTexts(htsAD);
            this.scrollAllDeals.setStacks(stacks);
            this.scrollDeals.setHoverTexts(htsD);
            this.scrollDeals.setStacks(marcetStacks);
            this.scrollDeals.setListNotSorted(marcetDeals);
        }
        if (selectedDeal != null) {
            this.scrollAllDeals.setSelected(selectedDeal.getSettingName());
        }
        this.scrollMarkets.guiLeft = x0;
        this.scrollMarkets.guiTop = y;
        this.scrollDeals.guiLeft = x1;
        this.scrollDeals.guiTop = y;
        this.scrollAllDeals.guiLeft = x2;
        this.scrollAllDeals.guiTop = y;
        this.addScroll(this.scrollMarkets);
        this.addScroll(this.scrollDeals);
        this.addScroll(this.scrollAllDeals);
        this.scrollMarkets.resetRoll();
        this.scrollDeals.resetRoll();
        this.scrollAllDeals.resetRoll();
        int lId = 0;
        GuiNpcLabel label = new GuiNpcLabel(lId++, "global.market", x0 + 2, y - 9);
        label.setHoverText("market.hover.names", new Object[0]);
        this.addLabel(label);
        label = new GuiNpcLabel(lId++, "market.deals", x1, y - 9);
        label.setHoverText("market.hover.deals", new Object[0]);
        this.addLabel(label);
        label = new GuiNpcLabel(lId, "market.all.deals", x2, y - 9);
        label.setHoverText("market.hover.all.deals", new Object[0]);
        this.addLabel(label);
        int bw = (w - 2) / 3;
        GuiNpcButton button = new GuiNpcButton(0, x0, y += h + 2, bw, 20, "gui.add");
        button.setHoverText("market.hover.market.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x0 + 2 + bw, y, bw, 20, "gui.remove");
        button.setEnabled(marcetId > 0 && selectedMarcet != null && this.mData.markets.size() > 1);
        button.setHoverText("market.hover.market.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, x0 + (2 + bw) * 2, y, bw, 20, "selectServer.edit");
        button.setEnabled(selectedMarcet != null);
        button.setHoverText("market.hover.market.settings", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, x2, y, bw, 20, "gui.add");
        button.setHoverText("market.hover.deal.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, x2 + 2 + bw, y, bw, 20, "gui.remove");
        button.setEnabled(dealId >= 0 && selectedDeal != null && this.dataDeals.size() > 1);
        button.setHoverText("market.hover.deal.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, x2 + (2 + bw) * 2, y, bw, 20, "selectServer.edit");
        button.setEnabled(selectedDeal != null);
        button.setHoverText("market.hover.deal.settings", new Object[0]);
        this.addButton(button);
        String[] tabs = new String[GuiNPCManageMarkets.selectedMarcet.sections.size()];
        int i = 0;
        for (MarcetSection tab : GuiNPCManageMarkets.selectedMarcet.sections.values()) {
            tabs[i] = new TextComponentTranslation(tab.name, new Object[0]).func_150254_d();
            ++i;
        }
        button = new GuiButtonBiDirectional(6, x1, y, w, 20, tabs, this.tabSelect);
        button.setHoverText("market.hover.section", new Object[0]);
        this.addButton(button);
        int x3 = x2 - 43;
        y = this.guiTop + 60;
        button = new GuiNpcButton(7, x3, y, 41, 20, "<");
        button.setEnabled(selectedMarcet != null && selectedMarcet.getDeal(dealId) == null && this.scrollAllDeals.hasSelected() && selectedDeal != null && selectedDeal.isValid());
        button.setHoverText("market.hover.add.deal", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(8, x3, y += 22, 41, 20, ">");
        button.setHoverText("market.hover.del.deal", new Object[0]);
        this.addButton(button);
        button.setEnabled(this.scrollDeals.hasSelected());
        button = new GuiNpcButton(9, x3, y += 22, 41, 20, "<<");
        button.setEnabled(!this.dataDeals.isEmpty());
        button.setHoverText("market.hover.add.deals", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(10, x3, y + 22, 41, 20, ">>");
        button.setEnabled(!this.scrollDeals.getList().isEmpty());
        button.setHoverText("market.hover.del.deals", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        if (selectedMarcet == null) {
            return;
        }
        Client.sendData(EnumPacketServer.TraderMarketSave, selectedMarcet.writeToNBT());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
        try {
            switch (scroll.getID()) {
                case 0: {
                    if (!this.dataMarkets.containsKey(scroll.getSelected())) {
                        return;
                    }
                    selectedMarcet = (Marcet)this.mData.getMarcet(this.dataMarkets.get(scroll.getSelected()));
                    marcetId = selectedMarcet.getId();
                    this.func_73866_w_();
                    break;
                }
                case 1: 
                case 2: {
                    if (!this.dataDeals.containsKey(scroll.getSelected())) {
                        return;
                    }
                    selectedDeal = (Deal)this.mData.getDeal(this.dataDeals.get(scroll.getSelected()));
                    dealId = selectedDeal.getId();
                    this.func_73866_w_();
                }
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        switch (scroll.getID()) {
            case 0: {
                if (selectedMarcet == null) {
                    return;
                }
                this.setSubGui(new SubGuiNpcMarketSettings(selectedMarcet));
                break;
            }
            case 1: 
            case 2: {
                if (selectedMarcet == null || !this.dataDeals.containsKey(scroll.getSelected())) {
                    return;
                }
                this.save();
                SubGuiNPCManageDeal.parent = this;
                NoppesUtil.requestOpenGUI(EnumGuiType.SetupTraderDeal, marcetId, dealId, 0);
            }
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.mData = MarcetController.getInstance();
        this.dataMarkets.clear();
        for (Marcet m : this.mData.markets.values()) {
            this.dataMarkets.put(m.getSettingName(), m.getId());
            if (marcetId >= 0 && marcetId != m.getId() && selectedMarcet != null) continue;
            selectedMarcet = m;
            marcetId = m.getId();
        }
        this.dataDeals.clear();
        for (Deal d : this.mData.deals.values()) {
            this.dataDeals.put(d.getSettingName(), d.getId());
            if (dealId >= 0 && dealId != d.getId() && selectedDeal != null) continue;
            selectedDeal = d;
            dealId = d.getId();
        }
        this.func_73866_w_();
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiNpcMarketSettings) {
            this.setGuiData(null);
        }
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
    }

    public static class TempDealInfo {
        public final String key;
        public final ItemStack stack;
        public final List<String> marcetInfo;

        public TempDealInfo(String keyIn, ItemStack stackIn, List<String> marcetInfoIn) {
            this.key = keyIn;
            this.stack = stackIn;
            this.marcetInfo = marcetInfoIn;
        }
    }
}

